<x-user.content>
    <x-slot:title>eCommerce MM</x-slot:title>
    <x-slot:head>
        <link rel="stylesheet" href="{{ asset('assets/') }}/admin/plugins/sweetalert2/sweetalert2.min.css">
    </x-slot:head>
    <div class="container">
        <div class="row px-xl-5 justify-content-center">
            <div class="col-lg-7">
                <nav class="breadcrumb bg-light mb-30">
                    <a class="breadcrumb-item text-dark" href="/">Home</a>
                    <span class="breadcrumb-item active">Daftar</span>
                </nav>
            </div>
        </div>
    </div>

    <div class="container">

        <div class="row px-xl-5 justify-content-center vh-100 ">
            <div class="col-lg-7 mb-5">
                <div class="contact-form bg-light p-30">
                    <div id="success"></div>

                    <div class="control-group">
                        <label for="">Nama Lengkap</label>
                        <input type="text" name="nm_member" class="form-control" id="nm_member"
                            placeholder="Nama Lengkap" required="required"
                            data-validation-required-message="Nama Lengkap" />
                        <p class="help-block text-danger"></p>
                    </div>

                    <div class="control-group mb-2">
                        <label for="">Jenis Kelamin</label>
                        <div class="d-flex justify-content-between ">
                            <div class="d-flex mr-5">
                                <input type="radio" name="jns_kelamin" class="form-control jns_kelamin" value="L"
                                    style="width: 20px" checked />
                                <span style="margin-left: 8px; margin-top: 10px;">Laki-Laki</span>
                            </div>
                            <input type="hidden" name="" id="jns_kelamin" value="L">
                            <div class="d-flex ">
                                <input type="radio" name="jns_kelamin" class="form-control jns_kelamin" value="P"
                                    style="width: 20px" />
                                <span style="margin-left: 8px; margin-top: 10px;">Perempuan</span>
                            </div>
                            <div class="d-flex ">
                            </div>
                            <div class="d-flex ">
                            </div>
                        </div>
                    </div>
                    <div class="control-group">
                        <label for="">Email</label>
                        <input type="email" name="email" class="form-control" id="email" placeholder="Email"
                            required="required" data-validation-required-message="Yang anda inputkan bukan email" />
                        <p class="help-block text-danger"></p>
                    </div>
                    <div class="control-group">
                        <label for="">No HP / WA</label>
                        <input type="text" name="no_hp" class="form-control" id="no_hp" placeholder="+628..."
                            required="required" data-validation-required-message="No HP / WA" />
                        <p class="help-block text-danger"></p>
                    </div>
                    <div class="control-group">
                        <label for="">Alamat Lengkap ( nama jalan, desa / kelurahan, dll)</label>
                        <textarea name="alamat" class="form-control" rows="8" id="alamat"
                            placeholder="Jl. Mayjend Sutoyo, Desa Paya Kumang...." required="required"
                            data-validation-required-message="Alamat Lengkap"></textarea>
                        <p class="help-block text-danger"></p>
                    </div>
                    <div class="control-group">
                        <label for="">Username</label>
                        <input type="text" class="form-control" id="username" placeholder="Username"
                            required="required" data-validation-required-message="Username" />
                        <p class="help-block text-danger"></p>
                        @error('username')
                            <small class="text-danger mt-2">
                                {{ $username }}
                            </small>
                        @enderror
                    </div>
                    <div class="control-group">
                        <label for="">Password</label>
                        <small class="text-info float-right">Pass minimal 6 digit</small>
                        <input type="password" class="form-control" id="password" placeholder="Password"
                            required="required" data-validation-required-message="Password" />
                        @error('password')
                            <small class="text-danger mt-2">
                                {{ $password }}
                            </small>
                        @enderror
                    </div>
                    <a href="/login" class="text-dark">Login?</a>
                    <div class="text-right">
                        <button class="btn btn-danger py-2 px-4" type="submit"
                            id="sendMessageButton">Daftar</button>
                    </div>
                </div>
            </div>

        </div>
    </div>


    <div class="vh-100"></div>

    <x-slot:foot>
        <script src="{{ asset('assets/') }}/admin/plugins/sweetalert2/sweetalert2.all.min.js"></script>
        <script>
            $('.jns_kelamin').click(function() {
                if ($(this).val() == "L") {
                    $('#jns_kelamin').val('L');
                } else {
                    $('#jns_kelamin').val('P');
                }
            });

            $('#sendMessageButton').click(function() {

                var token = $("meta[name='csrf-token']").attr("content");
                var nm_member = $('#nm_member').val();
                var email = $('#email').val();
                var hp_member = $('#no_hp').val();
                var alamat = $('#alamat').val();
                var username = $('#username').val();
                var password = $('#password').val();

                var jns_kelamin = $('#jns_kelamin').val();

                if (nm_member == "") {
                    $('#nm_member').focus();
                } else if (email == "") {
                    $('#email').focus();
                } else if (hp_member == "") {
                    $('#no_hp').focus();
                } else if (alamat == "") {
                    $('#alamat').focus();
                } else if (username == "") {
                    $('#username').focus();
                } else if (password == "") {
                    $('#password').focus();
                } else {
                    $.ajax({
                        type: 'POST',
                        url: 'registe-member',
                        data: {
                            nm_member: nm_member,
                            email: email,
                            hp_member: hp_member,
                            jns_kelamin: jns_kelamin,
                            alamat: alamat,
                            username: username,
                            password: password,
                            _token: token,
                        },
                        success: function(data) {
                            Swal.fire({
                                icon: "success",
                                title: "Berhasil",
                                text: "Registrasi Member berhasil, Silahkan Login!",
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    document.location.href = "/login";
                                }
                            });
                        }
                    });
                }
            })
        </script>
    </x-slot:foot>
</x-user.content>
